import { onPageLoadComplete } from '@nimius/event-utility';
import { loadOutdoorActive } from '../../Scripts/toubiz-poi/outdoor-active-api';
import { extractPrefixedAttributesFromElement } from '@nimius/dom-utility';

/**
 * @param {HTMLElement} element
 * @param {string} tourId
 */
function initializeOutdoorActiveMap(element, tourId) {
    loadOutdoorActive().then(oa => oa.api.maps((oamaps, gm) => {
        const { GeomLayer, map: initializeMap } = oamaps;
        const layer = new GeomLayer(tourId, { fitPoiBounds : true, defaultIW : true });

        layer.whenLoaded(() => {
            const mapTypeIds = [ 'oa_map', 'oa_hybrid', 'oa_map_winter' ];
            if (gm.MapTypeId) {
                mapTypeIds.push(gm.MapTypeId.TERRAIN);
                mapTypeIds.push(gm.MapTypeId.SATELLITE);
            }

            const zc = layer.getZoomCenter(element);
            const mapConfig = {
                center : zc.center,
                zoom : zc.zoom,
                bounds: layer.getBounds(),
                mapTypeId : mapTypeIds[ 0 ],
                mapTypeControlOptions : { mapTypeIds },
                oa : { earth : true },
            };

            const map = initializeMap(element, mapConfig);
            layer.setMap(map);
        });
    }));
}

onPageLoadComplete(async () => {
    const resultsNode = document.querySelector('[data-toubiz-results="poi"]');
    if (resultsNode) {
        // eslint-disable-next-line max-len
        const { default: ToubizPoiResultsListController } = await import(/* webpackChunkName: "toubiz-poi-results-list-controller" */ '../../Scripts/toubiz-poi/results-list-controller');
        new ToubizPoiResultsListController(resultsNode);
    }
});

onPageLoadComplete(async () => {
    if (document.querySelector('[data-toubiz-opening-times]')) {
        // eslint-disable-next-line max-len
        const { default: parseOpeningTimes } = await import(/* webpackChunkName: "parse-opening-times" */ '../../Scripts/toubiz-poi/parse-opening-times');

        for (const node of document.querySelectorAll('[data-toubiz-opening-times]')) {
            parseOpeningTimes(node);
        }
    }
});

onPageLoadComplete(() => {
    if (document.querySelector('[data-oa-tracking]')) {
        for (const teaser of document.querySelectorAll('[data-oa-tracking-type="teaser"]')) {
            loadOutdoorActive().then(ax => ax.api.trackTeaser(teaser.dataset.oaTrackingId));
        }

        for (const tour of document.querySelectorAll('[data-oa-tracking-type="detail"]')) {
            loadOutdoorActive().then(ax => ax.api.trackDetail(tour.dataset.oaTrackindId));
        }
    }
});

onPageLoadComplete(() => {
    if (document.querySelector('[data-oa-map]')) {
        for (const tour of document.querySelectorAll('[data-oa-tour-id]')) {
            initializeOutdoorActiveMap(tour, tour.dataset.oaTourId);
        }
    }
});

onPageLoadComplete(async () => {
    const elements = document.querySelectorAll('[data-toubiz-static-map]');
    if (elements.length > 0) {
        // eslint-disable-next-line max-len
        const { StaticMap } = await import(/* webpackChunkName: "static-map" */ '../../Scripts/static-map/static-map');
        for (const map of elements) {
            new StaticMap(map, extractPrefixedAttributesFromElement(map, 'data-toubiz-static-map.'));
        }
    }
});


onPageLoadComplete(async () => {
    const elements = document.querySelectorAll('[data-outdooractive-pdf-download]');
    if (elements.length > 0) {
        // eslint-disable-next-line max-len
        const { OutdoorActivePdfDownload } = await import(/* webpackChunkName: "outdoor-active-pdf-download" */ '../../Scripts/toubiz-poi/outdoor-active-pdf-download');
        for (const button of document.querySelectorAll('[data-outdooractive-pdf-download]')) {
            new OutdoorActivePdfDownload(button, button.getAttribute('data-outdooractive-pdf-download'));
        }
    }
});

