import { GoogleMapsStatic } from './map/google-maps-static';
import { GoogleMap } from '../toubiz-map/map/google-maps/google-map';
import { MapToolkitStatic } from './map/map-toolkit-static';
import { MapToolkit } from '../toubiz-map/map/maptoolkit/map-toolkit';

/**
 * Both, static and dynamic must be constructors of subclasses of
 * `AbstractMapWithMarker`. This however cannot be expressed in JSDoc
 * syntax.
 *
 * @typedef {object} StaticMapPair
 * @property {*} Static
 * @property {*} Dynamic
 */

/**
 * @type {object<string, StaticMapPair>}
 */
const mapTypes = {
    'google-maps': {
        Static: GoogleMapsStatic,
        Dynamic: GoogleMap,
    },
    toursprung: {
        Static: MapToolkitStatic,
        Dynamic: MapToolkit,
    },
};

/**
 * @param {string} type
 * @returns {StaticMapPair}
 */
export function getMapConstructors(type) {
    if (!mapTypes[type]) {
        throw new Error(`Static map: map type ${type} invalid`);
    }

    return mapTypes[type];
}
