import { AbstractMapWithMarkers } from '../../toubiz-map/map/abstract-map-with-markers';

/**
 * Small layer that handles common functionality of static maps (e.g. rendering an image)
 * that allows easier implementation of static maps as these only have to generate image
 * urls now.
 *
 * @abstract
 */
export class AbstractStaticMap extends AbstractMapWithMarkers {

    /**
     * @param {Marker[]} markers
     * @return {string}
     * @protected
     * @abstract
     */
    imageUrl(markers) {
        throw new Error('This method must be implemented in subclasses');
    }

    /**
     * @param {Marker[]} markers
     * @protected
     */
    render(markers) {
        if (!this.picture) {
            if (this.node.nodeName.toLowerCase() === 'picture') {
                this.picture = this.node;
            } else {
                this.picture = document.createElement('picture');
                this.node.appendChild(this.picture);
            }

            this.picture.setAttribute('width', this.options.width);
            this.picture.setAttribute('height', this.options.height);
        }

        this.source = document.createElement('source');
        this.picture.appendChild(this.source);

        this.sourcePhone = document.createElement('source');
        this.picture.appendChild(this.sourcePhone);

        this.image = document.createElement('img');
        this.picture.appendChild(this.image);

        this.source.setAttribute('srcset', this.imageUrl(markers));
        this.source.setAttribute('media', '(min-width: 768px)');
        this.sourcePhone.setAttribute('srcset', this.mobileImageUrl(markers));
        this.image.setAttribute('src', this.imageUrl(markers));
    }

    prepareOptions (options) {
        options = super.prepareOptions(options);
        options.width = options.width || 800;
        options.height = options.height || 600;
        options.zoom = options.zoom || 85;

        return options;
    }


}
