import { isDevelopmentBuild } from '../base/environment';
import { parseStringAsDom } from '@nimius/dom-utility';

export function notifyErrorIfInDevelopment(error) {
    if (!isDevelopmentBuild()) {
        return;
    }

    if (typeof error === 'object' && typeof error.error === 'object') {
        error = error.error;
    }
    if (typeof error === 'object' && typeof error.message === 'string') {
        error = error.message
    }
    if (typeof error !== 'string') {
        error = JSON.stringify(error);
    }

    const element = parseStringAsDom(`
        <div
            class="fixed p-8 m-8 border-orange border-4 bg-white shadow-md" 
            style="top: 0; right: 0; min-width: 250px; z-index: 9999999"
        >
            <code class="block">${error}</code>
            <small class="block">Check developer tools for more information</small>
        </div>
    `)[0];
    window.document.body.appendChild(element);

    setTimeout(() => window.document.body.removeChild(element), 10000);
}
