import { ChildFilter } from './child-filter';
import { expect } from 'chai';

describe('ChildFilter', () => {
    let dom;
    let filter;

    beforeEach(() => {
        dom = document.createElement('div');
        dom.innerHTML = `
            <input style="display: none">
            <ul>
                <li>Foo</li>
                <li>Bar</li>
                <li>Baz</li>
                <li>FooBar</li>
                <li>FooBarBaz</li>
            </ul>
        `;
        filter = new ChildFilter(dom, {
            selector: 'li',
            query: 'input',
        });
    });

    it('should reveal the hidden input', () => {
        expect(dom.querySelector('input').style.display).to.not.equal('none');
    });

    it('Should hide elements not matching the search string', () => {
        filter.apply('Foo');
        expect(dom.querySelector('li:nth-child(1)').style.display).to.not.equal('none');
        expect(dom.querySelector('li:nth-child(2)').style.display).to.equal('none');
        expect(dom.querySelector('li:nth-child(3)').style.display).to.equal('none');
        expect(dom.querySelector('li:nth-child(4)').style.display).to.not.equal('none');
        expect(dom.querySelector('li:nth-child(5)').style.display).to.not.equal('none');

        filter.apply('Baz');
        expect(dom.querySelector('li:nth-child(1)').style.display).to.equal('none');
        expect(dom.querySelector('li:nth-child(2)').style.display).to.equal('none');
        expect(dom.querySelector('li:nth-child(3)').style.display).to.not.equal('none');
        expect(dom.querySelector('li:nth-child(4)').style.display).to.equal('none');
        expect(dom.querySelector('li:nth-child(5)').style.display).to.not.equal('none');
    });

    it('should ignore casing when searching', () => {
        filter.apply('fooBAR');
        expect(dom.querySelector('li:nth-child(1)').style.display).to.equal('none');
        expect(dom.querySelector('li:nth-child(2)').style.display).to.equal('none');
        expect(dom.querySelector('li:nth-child(3)').style.display).to.equal('none');
        expect(dom.querySelector('li:nth-child(4)').style.display).to.not.equal('none');
        expect(dom.querySelector('li:nth-child(5)').style.display).to.not.equal('none');
    });

    it('should call the callback when filtering', () => {
        let called = false;
        const f = new ChildFilter(dom, {
            selector: 'li',
            query: 'input',
            onApply: () => called = true,
        });
        f.apply('foo');
        expect(called).to.equal(true, 'Callback should have been called');
    });

});
