/**
 * @typedef {object} Marker~Style
 * @property {string} iconUrl
 * @property {number} width - Width of the marker on the map in pixels
 * @property {number} height - Height of the marker on the map in pixels
 * @property {number} offsetX - X-Position of the tip of the marker image
 * @property {number} offsetY - Y-Position of the tip of the marker image
 */

/**
 * @typedef {object} Marker~Coordinates
 * @property {number} latitude
 * @property {number} longitude
 */

/**
 * @typedef {object} Marker~TourProperties
 * @typedef {number[][]} polygon
 * @typedef {number} difficultyRating
 * @typedef {bool} alwaysDisplayPolygon
 * @typedef {string} color
 */

/**
 * @typedef {object} Marker~Image
 * @typedef {string} url
 * @typedef {string} alt
 */

export class Marker {

    constructor () {
        /** @public {string} */
        this.title = '';

        /** @public {string} */
        this.categoryTitle = '';

        /** @public {Marker~Image|null} */
        this.image = null;

        /** @public {string[]} */
        this.paths = [];

        /** @public {Marker~Style} */
        this.style = {};

        /** @public {Marker~Style} */
        this.defaultStyle = {};

        /** @public {Marker~Coordinates} */
        this.coordinates = { latitude: 0, longitude: 0 };

        /** @public {Marker~TourProperties|null} */
        this.tour = null;

        /** @public {string|null} */
        this.outdoorActiveTrackingId = null;

        /** @public {string|null} */
        this.url = null;

        /** @public {Object<string, string>} */
        this.detailApiEndpoints = {};

        /** @public {Object} */
        this.detail = {};
    }

}
