import { AbstractStaticMap } from './abstract-static-map';
import { stripMultilineIndention } from '../../common/string-utilities';

export class MapToolkitStatic extends AbstractStaticMap {

    prepareOptions (options) {
        options = super.prepareOptions(options);

        if (!options.toursprungApiKey) {
            console.warn(stripMultilineIndention(`
                ## Toubiz Map Configuration Warning
                Using toursprung map without API key. Please provide a valid API key.
            `));
            options.toursprungApiKey = 'sandbox';
        }
        return options;
    }

    imageUrl (markers) {
        const urlParameters = [
            'maptype=terrain-v2',
            `size=${this.options.width}x${this.options.height}`,
            `zoom=${Math.round(this.options.zoom * 18 / 100)}`,
        ];

        for (const marker of markers) {
            urlParameters.push(`marker=center:${marker.coordinates.latitude},${marker.coordinates.longitude}`);

            if (marker.tour && marker.tour.polygon) {
                const polygon = marker.tour.polygon.map(([ latitude, longitude ]) => `${latitude},${longitude}`);
                urlParameters.push(`path=color:FF000088|points:${polygon.join('|')}`);
            }
        }

        return `https://staticmap.maptoolkit.net/?${urlParameters.join('&')}`;
    }

}
