import { stripMultilineIndention } from '../../common/string-utilities';
import { AbstractStaticMap } from './abstract-static-map';

export class GoogleMapsStatic extends AbstractStaticMap {

    prepareOptions (options) {
        options = super.prepareOptions(options);

        options.googleMapStyle = options.googleMapStyle || [ 'roadmap' ];
        if (!options.googleMapsApiKey) {
            console.warn(stripMultilineIndention(`
                ## Toubiz Map Configuration Warning
                No google maps api key supplied
            `));
        }

        return options;
    }

    imageUrl(markers) {
        const urlParameters = [
            `zoom=${Math.round(this.options.zoom * 18 / 100)}`,
            `size=${this.options.width}x${this.options.height}`,
            'scale=2',
            `maptype=${this.options.googleMapStyle[0]}`,
        ];

        if (this.options.googleMapsApiKey) {
            urlParameters.push(`key=${this.options.googleMapsApiKey}`);
        }

        for (const marker of markers) {
            urlParameters.push(`markers=${marker.coordinates.latitude},${marker.coordinates.longitude}`);
            if (marker.tour && marker.tour.polygon) {
                const polygon = marker.tour.polygon.map(([ latitude, longitude ]) => `${latitude},${longitude}`);
                urlParameters.push(`path=color:red|${polygon.join('|')}`);
            }
        }

        return `https://maps.googleapis.com/maps/api/staticmap?${urlParameters.join('&')}`;
    }

}
