import { AbstractMapWithMarkers } from '../../toubiz-map/map/abstract-map-with-markers';

/**
 * Small layer that handles common functionality of static maps (e.g. rendering an image)
 * that allows easier implementation of static maps as these only have to generate image
 * urls now.
 *
 * @abstract
 */
export class AbstractStaticMap extends AbstractMapWithMarkers {

    /**
     * @param {Marker[]} markers
     * @return {string}
     * @protected
     * @abstract
     */
    imageUrl(markers) {
        throw new Error('This method must be implemented in subclasses');
    }

    /**
     * @param {Marker[]} markers
     * @protected
     */
    render(markers) {
        if (!this.image) {
            if (this.node.nodeName.toLowerCase() === 'img') {
                this.image = this.node;
            } else {
                this.image = document.createElement('img');
                this.node.appendChild(this.image);
            }

            this.image.setAttribute('width', this.options.width);
            this.image.setAttribute('height', this.options.height);
        }

        this.image.setAttribute('src', this.imageUrl(markers));
    }

    prepareOptions (options) {
        options = super.prepareOptions(options);
        options.width = options.width || 800;
        options.height = options.height || 600;
        options.zoom = options.zoom || 85;

        return options;
    }


}
